/*------------------------------------------------------------------------
                  HTMLEx V1.07 - HTML Enhancement Filter
      ISAPI Filter (DLL) for Microsoft Internet Information Server
--------------------------------------------------------------------------
(c)Zoltan Pekic, 1996. zoltanp@rijeka.riteh.hr, administrator@www.riteh.hr
--------------------------------------------------------------------------
 THIS SOFTWARE IS FREEWARE - IT MAY BE FREELY COPIED, DISTRIBUTED
  AND ENHANCED IN FUNCTIONALITY AS LONG AS THE ORIGINAL AUTHOR'S
                         NAME IS PRESERVED
------------------------------------------------------------------------*/
#include <windows.h>
#include <winsock.h>  // include wsock32.lib in Project Settings (Link)
#include <stdio.h>
#include <stdlib.h>
#include <httpfilt.h> // From ISAPI SDK
#include <time.h>

#define MAX_WRITEBUFF 8192 // Magic number...

#define MAX_EXPAND    8192 // Filtered HTM max. 8k longer than the original!
#define MAX_TAG         64 // Place for upto 64 different HTMLEx tags
#define MAX_TAGNAME     32 // Max length of tag's name
#define MAX_TAGVALUE  2048 // Max length of tag's expanded value

#define KEY_W3SVC  "SYSTEM\\CurrentControlSet\\Services\\W3SVC"
#define KEY_PARAMS "Parameters"
#define KEY_HTMLEX "HTMLEx"
#define KEY_DIGITS "Digits"
#define KEY_TAGS   "Tags"

// Hard-coded defaults which can be overriden by registry
#define DEFAULTLOADFILE        "Default.htm" 
#define EXPANDABLEEXTENSIONS   ".htm,.html,.stm,.shtm,.shtml"
#define UNEXPANDABLEEXTENSIONS ".exe,.dll"
#define DATEFORMAT             "%A, %B %d, %Y."
#define TIMEFORMAT             "%H:%M:%S"
#define DIGITCNT               5
#define EXPANDBYDEFAULT        1  // Yes, <!HTMLEx noexpand> needed to skip!
#define EXPANDDEFAULTPAGES     1
#define EXPANDOTHERPAGES       1
#define GENERATELOGS           1
#define MAXLOGFILESIZE         64 // By default, let LOG files grow to a maximum of 64k
#define IGNOREADDRESS          "0.0.0.0" // ie, none!
#define TAG_START              "%"
#define TAG_END                "%"


const char *pcHTMLExDesc="HTMLEx/1.07 - HTML Enhancement Filter",
           *pcHTMLExVer="<a href=\042http://161.53.40.11/HTMLEx/default.htm\042>HTMLEx/1.07</a>",
		   *pcHTMLExAuthor="&copy;<a href=\042mailto:zoltanp@rijeka.riteh.hr\042>Zoltan Pekic</a>, 1996.";

//
// Needed in Debug mode
//
BOOL   bDebugMode=FALSE;
HANDLE hStdErr=NULL;

HANDLE hEvent;
HKEY   hKeyHTMLEx,hKeyTags;
// From KEY_PARAMS
char cRegDefault_Load_File[128];
// From KEY_HTMLEX
char cRegExpandableExtensions[128];
char cRegUnexpandableExtensions[128];
char cRegTagStart[16],cRegTagEnd[16];
char cRegIgnoreAddress[128];
char cRegDateFormat[128];
char cRegTimeFormat[128];
char cRegDigitImg[10][128];   
const char *pcDefaultDigitImg[]={"/0.gif","/1.gif","/2.gif","/3.gif","/4.gif","/5.gif","/6.gif","/7.gif","/8.gif","/9.gif"};
DWORD dwRegDigitCnt;
DWORD dwRegExpandByDefault;
DWORD dwRegExpandDefaultPages;
DWORD dwRegExpandOtherPages;
DWORD dwRegGenerateLogs;
DWORD dwRegMaxLogFileSize;
//
// If URLs destination in one of these directories, then skip it!
//
#define MAX_SKIPDIR  16
int     iSkipdirCount=0;
char    cSkipdir[MAX_SKIPDIR][256];


// Record some events in Applications Event Log
//
void Report(WORD wEventType,DWORD dwEventID,char* pcFormat,char* pcArg)
{
 char cBuff[1024];		  

 if (bDebugMode)
 {
  char cFormat[256];
  DWORD dwWritten;
  switch(wEventType)
  {
   case EVENTLOG_ERROR_TYPE      :sprintf(cFormat,"\n***E%03i - %s",dwEventID,pcFormat);break;
   case EVENTLOG_WARNING_TYPE    :sprintf(cFormat,"\n***W%03i - %s",dwEventID,pcFormat);break;
   case EVENTLOG_INFORMATION_TYPE:sprintf(cFormat,"\n***I%03i - %s",dwEventID,pcFormat);break;
   default                       :sprintf(cFormat,"\n***U%03i - %s",dwEventID,pcFormat);break;
  };
  WriteConsole(hStdErr,cBuff,sprintf(cBuff,cFormat,pcArg),&dwWritten,NULL);
 }
 else
 {
  const char *pcBuff=cBuff;
  sprintf(cBuff,pcFormat,pcArg);
  if (hEvent) ReportEvent(hEvent,wEventType,0,dwEventID,NULL,1,0,&pcBuff,NULL); 
 };
};

void TagConst(char *pcName,char *pcValue,char *pcTagName,const char *pcTagValue)
{
 strcpy(pcName,pcTagName);
 strcpy(pcValue,pcTagValue);
};

void TagServVar(char *pcName,char *pcValue,char *pcTagName,HTTP_FILTER_CONTEXT *pfc,char *pcServVarName,char* pcDefault)
{
 DWORD dwValueLen=MAX_TAGVALUE;
 TagConst(pcName,pcValue,pcTagName,pcDefault);
 (pfc->GetServerVariable)(pfc,pcServVarName,pcValue,&dwValueLen);
// Report(EVENTLOG_INFORMATION_TYPE,3,"%s",pcName);
// Report(EVENTLOG_INFORMATION_TYPE,4,"%s",pcValue);
};
		
void GraphCnt(int iCnt,int iLen,char* pcImg,char* pcGraphCnt)
{
 char  cImg[MAX_TAGVALUE],cDigits[16],cFormat[16]; 

 sprintf(cFormat," 0%ii",(iLen>9 ? 9 : (iLen<2 ? 2 : iLen)));cFormat[0]='%';
 sprintf(cDigits,cFormat,iCnt);
 char* pcDigits=cDigits;
 while (*pcDigits)
 {
  sprintf(cImg,"<img src=\042%s\042 alt=\042%c\042>",pcImg+128*((int) *pcDigits-'0'),*pcDigits);
  strcat(pcGraphCnt,cImg);
  pcDigits++;
 };
};

char *WSErrMsg(int WSErrCode)
{
 switch (WSErrCode)
 {
  case WSANOTINITIALISED:return ("WSAStartup failure.");break;
  case WSAENETDOWN      :return ("Network subsystem failure.");break;
  case WSAHOST_NOT_FOUND:return ("Authoritative Answer Host not found.");break;
  case WSATRY_AGAIN	    :return ("Non-Authoritative Host not found, or SERVERFAIL.");break;
  case WSANO_RECOVERY   :return ("Non recoverable errors, FORMERR, REFUSED, NOTIMP.");break;
  case WSANO_DATA       :return ("Valid name, no data record of requested type.");break;
  case WSAEINPROGRESS   :return ("A blocking Windows Sockets operation is in progress.");break;
  case WSAEINTR         :return ("The (blocking) call was canceled via WSACancelBlockingCall.");break;
  default               :return ("Unspecified WinSock error.");
 };
};

// This can be a time consuming task on slow networks!
// Use the %CurrentClientHost% tag sparingly!
//
void ResolveIPAddress(char* pcHost)
{
 hostent *pHE=NULL;
 long lAddress;
 char cBuff[256],*pcHN;
 BOOL bDottedDecimal=TRUE;
  
 pcHN=pcHost;
 while (*pcHN && bDottedDecimal)
 {
  bDottedDecimal=((*pcHN>='.') && (*pcHN<='9'));
  ++pcHN;
 };
 if (bDottedDecimal)	                // Already done?
 {										// No, some Winsock labour required...
  lAddress=inet_addr(pcHost);
  if (lAddress==INADDR_NONE)
  {
   sprintf(cBuff,"<IP address %s is invalid>",pcHost);
   Report(EVENTLOG_WARNING_TYPE,103,"%s",cBuff);
   strcpy(pcHost,cBuff);
  }
  else                      
  {
   if (pHE=gethostbyaddr((char*) &lAddress,4,PF_INET)) strcpy(pcHost,pHE->h_name);
   else	
   {
    sprintf(cBuff,"<%s ... %s>",pcHost,WSErrMsg(WSAGetLastError()));
    Report(EVENTLOG_WARNING_TYPE,104,"%s",cBuff);
    strcpy(pcHost,cBuff);
   }
  }
 }
};

void ST2TM(SYSTEMTIME* pST,struct tm* pTM) // Glue C++ runtime and Win32 API together
{
 pTM->tm_year=(int) pST->wYear-1900;
 pTM->tm_mon= (int) pST->wMonth-1;
 pTM->tm_mday=(int) pST->wDay;
 pTM->tm_hour=(int) pST->wHour;
 pTM->tm_min= (int) pST->wMinute;
 pTM->tm_sec= (int) pST->wSecond;
 pTM->tm_wday=(int) pST->wDayOfWeek;
 pTM->tm_yday=0;   // No need for complicated calculations...
 pTM->tm_isdst=-1; // Unknown daylight status, but who cares for a few little hours...
};

void GetRidOfNullChars(char* pcS,char cReplacement)
{
 BOOL bCont=TRUE;

 while (bCont)
 {
  if(*pcS=='\0')
  {
   *pcS++=cReplacement;
   bCont=(*pcS != '\0');
  }
  else pcS++;
 };
};

BOOL GetValueFromTagKeyInINI(char* pcININame,char* pcTagN,char* pcTagV)
{
 GetPrivateProfileString(KEY_TAGS,pcTagN,pcTagN,pcTagV,MAX_TAGVALUE,pcININame);
 return (strcmp(pcTagN,pcTagV));
};

BOOL GetValueFromTagKeyInReg(HKEY hKeyActual,char* pcTagN,char* pcTagV)
{
 DWORD dwValLen,dwType;
 char cUnExpanded[MAX_TAGVALUE];

 if (hKeyActual)
 {
  dwValLen=MAX_TAGVALUE;
  if(RegQueryValueEx(hKeyActual,pcTagN,NULL,&dwType,(LPBYTE) cUnExpanded,&dwValLen) == ERROR_SUCCESS)
  {
   if (dwType==REG_MULTI_SZ) GetRidOfNullChars(cUnExpanded,'\n');
   ExpandEnvironmentStrings(cUnExpanded,pcTagV,MAX_TAGVALUE);
   return (TRUE);
  };
 };
 return (FALSE);
};

BOOL PickValueFromRandomKeyInINI(char* pcININame,char* pcTagN,char* pcTagV)
{
 char cRandomLine['Z'-'A'+1][MAX_TAGVALUE];
 int  iRandomCnt=0;
 char cRandomEntryName[8],cRandomEntryDefault[8];

 for(char c='A';c<='Z';c++)
 {
  sprintf(cRandomEntryName,"c%c",c);
  sprintf(cRandomEntryDefault,"c%c",c);
  GetPrivateProfileString(pcTagN,cRandomEntryName,cRandomEntryDefault,cRandomLine[iRandomCnt],MAX_TAGVALUE,pcININame);
  if (strcmp(cRandomEntryDefault,cRandomLine[iRandomCnt])) iRandomCnt++;
 };
 if (iRandomCnt)
 {
  strcpy(pcTagV,cRandomLine[rand() % iRandomCnt]);
  return (TRUE);
 };
 return (FALSE);
};

BOOL PickValueFromRandomKeyInReg(HKEY hKeyParent,char* pcTagN,char* pcTagV)
{
 char cRandomLine['Z'-'A'+1][MAX_TAGVALUE];
 char cUnExpanded[MAX_TAGVALUE];
 int  iRandomCnt=0;
 char cRandomEntryName[8];
 HKEY hKeyRandom;
 DWORD dwValLen,dwType;

 if(hKeyParent)
 {
  if (RegOpenKeyEx(hKeyParent,pcTagN,0,KEY_READ,&hKeyRandom)==ERROR_SUCCESS) 
  {
   for(char c='A';c<='Z';c++)
   {
    sprintf(cRandomEntryName,"%c",c); // Note: not cA..cZ, just A...Z
    dwValLen=sizeof(cRandomLine[0]);
    if (RegQueryValueEx(hKeyRandom,cRandomEntryName,NULL,&dwType,(LPBYTE) cUnExpanded,&dwValLen) == ERROR_SUCCESS)
    {
	 if (dwType==REG_MULTI_SZ) GetRidOfNullChars(cUnExpanded,'\n');
	 ExpandEnvironmentStrings(cUnExpanded,cRandomLine[iRandomCnt],MAX_TAGVALUE);
	 iRandomCnt++;
	};
   };
   RegCloseKey(&hKeyRandom);
   if (iRandomCnt)
   {
    strcpy(pcTagV,cRandomLine[rand() % iRandomCnt]);
    return (TRUE);
   };
  };
 };
 return (FALSE);
};

void HTMLExpand(HTTP_FILTER_CONTEXT *pfc,char* pcHTMName,char* pcININame,char* pcLOGName)
{
 WIN32_FIND_DATA HTMInfo;
 SYSTEMTIME      ST;
 tm              TM;
 OFSTRUCT        OFS;
 DWORD           dwFileRW; 
 DWORD           dwHTMExSize;
 char            cBuff[256];
 char            cTagN[MAX_TAGVALUE],cTagV[MAX_TAGVALUE];
 char            *pcHTM=NULL,*pcS,*pcF1,*pcF2,*pcD;
 int             iCat,i,j;
 char            cTagName[MAX_TAG][MAX_TAGNAME],cTagValue[MAX_TAG][MAX_TAGVALUE];
 char            cRawTag[MAX_TAGNAME];
 BOOL            bTagFound;

 time_t          Now;
 char            cTodaysDate[64],cTextCnt[32];
// [LastAccess]  section, will be updated!
 char            cDate[128],cTime[128];
 char            cIP[128],cRemoteIP[128];
 char            cHost[128],cLastHost[128];
 char            cBrowser[256];
 int             iCnt;              // Default: 0 
// [Log]         section, read only, except cStartDate!
 char            cIgnoreAddress[128]; // Default: cRegIgnoreAddress 
 char            cStartDate[128];     // Default: <cTodaysDate>
 char            cDateFormat[128];    // Default: cRegDateFormat
 char            cTimeFormat[128];    // Default: cRegTimeFormat
 int             iDigitCnt;		      // Default: dwRegDigitCnt, Valid: 2..9
// [Config]      section, read only!
 char            cTagStart[16],cTagEnd[16]; // Default: cRegTag...
 DWORD           dwLenTS,dwLenTE;
// [Digits]      section, read only!
 char            cDigitImg[10][128];   
// Control this page via <!HTMLEx [noexpand] [nolog] [justcount] [noctags] [nortags]>
 char          	*pcControlTag;
 DWORD           dwLogThisOne=1;    // Log by default
 DWORD           dwJustCount=0;	    // Do everything, don't just count
 BOOL            bExpandCTags=TRUE; // Expand constant tags
 BOOL            bExpandRTags=TRUE; // Expand random tags
// Logging...
 BY_HANDLE_FILE_INFORMATION LOGInfo;
 BOOL            bZapLOGFile;
 int             iMaxLogFileSize;   // Default: dwRegMaxLogFileSize
// Count this hit ...
 BOOL            bCountThisHit=TRUE; // YES, OF COURSE!


 if (FindFirstFile(pcHTMName,&HTMInfo) == INVALID_HANDLE_VALUE)
 {
  Report(EVENTLOG_ERROR_TYPE,202,"FindFirstFile(%s,) failed.",pcHTMName);
  return; //Should never fail here - unless there is really no such file...
 }
 HFILE HTMHandle=OpenFile(pcHTMName,&OFS,OF_READ | OF_SHARE_DENY_WRITE);
 if (HTMHandle==HFILE_ERROR)
 {
  Report(EVENTLOG_ERROR_TYPE,203,"OpenFile(%s,,OF_READ | OF_SHARE_DENY_WRITE) failed.",pcHTMName);
  return;										//And here neither? 
 };
 if (HTMInfo.nFileSizeHigh != 0)  //This is beyond any reason...
 {
  Report(EVENTLOG_WARNING_TYPE,204,"File %s is too large.",pcHTMName);
  return;                                    
 };
 dwHTMExSize=HTMInfo.nFileSizeLow+MAX_EXPAND;
 pcHTM=(char*)GlobalAlloc(GPTR,dwHTMExSize);
 if (pcHTM == NULL)
 {
  ltoa(dwHTMExSize,cBuff,10);
  Report(EVENTLOG_ERROR_TYPE,205,"GlobalAlloc(,%s) failed.",cBuff);
  return;
 };
 if (!ReadFile((HANDLE) HTMHandle,pcHTM,HTMInfo.nFileSizeLow,&dwFileRW,NULL))
 {
  GlobalFree(pcHTM);
  Report(EVENTLOG_ERROR_TYPE,206,"%s - ReadFile() failed.",pcHTMName); 
  return;
 };
 CloseHandle((HANDLE) HTMHandle);
 pcControlTag=strstr(pcHTM,"<!HTMLEx"); // case sensitive!
 if (pcControlTag)	 
 {
  if (dwRegExpandByDefault ? (strstr(pcControlTag,"noexpand")!=NULL) : (strstr(pcControlTag,"expand")==NULL))
  {
   GlobalFree(pcHTM);
   return;  
  };
  if (strstr(pcControlTag,"nolog")) dwLogThisOne=0;       // case sensitive!
  if (strstr(pcControlTag,"justcount")) dwJustCount=1;    // case sensitive!
  if (strstr(pcControlTag,"noctags")) bExpandCTags=FALSE; // case sensitive!
  if (strstr(pcControlTag,"nortags")) bExpandRTags=FALSE; // case sensitive!
 }
 else
 {
  if (!dwRegExpandByDefault)
  {
   GlobalFree(pcHTM);
   return;  
  }
 };
//
// Mark this exact moment (and initialize the pseudo-random generator pseudo-randomly!)
//
 srand((unsigned) time(&Now));
 i=1;
 TagConst(cTagName[i],cTagValue[i],"%%","%");i++;
 TagConst(cTagName[i],cTagValue[i],"%HTMLExAuthor%",pcHTMLExAuthor);i++;
 TagConst(cTagName[i],cTagValue[i],"%HTMLExVer%",pcHTMLExVer);i++;
 TagServVar(cTagName[i],cTagValue[i],"%REMOTE_ADDR%",pfc,"REMOTE_ADDR","<Unknown IP address>");i++;
 strcpy(cRemoteIP,cTagValue[i-1]);
//
// INI File - [Config] Section
//
 GetPrivateProfileString("Config","cTagStart",cRegTagStart,cTagStart,sizeof(cTagStart),pcININame);
 dwLenTS=strlen(cTagStart);
 GetPrivateProfileString("Config","cTagEnd"  ,cRegTagEnd  ,cTagEnd  ,sizeof(cTagEnd)  ,pcININame);
 dwLenTE=strlen(cTagEnd);
//
// INI File - [Log] Section
//
 iMaxLogFileSize=GetPrivateProfileInt("Log","iMaxLogFileSize",(int) dwRegMaxLogFileSize,pcININame);
 if (iMaxLogFileSize<0) iMaxLogFileSize=0; 
 GetPrivateProfileString("Log","cDateFormat",cRegDateFormat,cDateFormat,sizeof(cDateFormat),pcININame);
 GetPrivateProfileString("Log","cTimeFormat",cRegTimeFormat,cTimeFormat,sizeof(cTimeFormat),pcININame);
 GetPrivateProfileString("Log","cIgnoreAddress",cRegIgnoreAddress,cIgnoreAddress,sizeof(cIgnoreAddress),pcININame);
 if (strstr(cIgnoreAddress,cIP)) bCountThisHit=FALSE;
 strftime(cTodaysDate,sizeof(cTodaysDate),cDateFormat,localtime(&Now));
 GetPrivateProfileString("Log","cStartDate",cTodaysDate,cStartDate,sizeof(cStartDate),pcININame);
 TagConst(cTagName[i],cTagValue[i],"%LogStartDate%",cStartDate);i++;
 if (bCountThisHit) WritePrivateProfileString("Log","cStartDate",cStartDate,pcININame);
//
// Do everything needed for counting 
//
 iDigitCnt=GetPrivateProfileInt("Log","iDigitCnt",(int) dwRegDigitCnt,pcININame);
 strcpy(cBuff,"cX");           // Keys:     c0=... , c1=... , ... , c9=...
 for(j=0;j<10;j++)
 {
  cBuff[1]=(char) 48+j;
  GetPrivateProfileString(KEY_DIGITS,cBuff,cRegDigitImg[j],cDigitImg[j],sizeof(cDigitImg[0]),pcININame);
  if (strlen(cDigitImg[j])==0) strcpy(cDigitImg[j],pcDefaultDigitImg[j]);
 };
 sprintf(cTextCnt,"%i",iCnt=GetPrivateProfileInt("LastAccess","iCnt",0,pcININame));
 TagConst(cTagName[i],cTagValue[i],"%LastCnt%",cTextCnt);i++;
 TagConst(cTagName[i],cTagValue[i],"%LastGraphCnt%"," ");GraphCnt(iCnt,iDigitCnt,&cDigitImg[0][0],cTagValue[i]);i++;
 if (bCountThisHit) iCnt++;
 sprintf(cTextCnt,"%i",iCnt);TagConst(cTagName[i],cTagValue[i],"%CurrentCnt%",cTextCnt);i++;
 TagConst(cTagName[i],cTagValue[i],"%CurrentGraphCnt%"," ");GraphCnt(iCnt,iDigitCnt,&cDigitImg[0][0],cTagValue[i]);i++;
//
// A feature, not a bug: Random tags and IP address resolving still operational!
//
 TagServVar(cTagName[i],cTagValue[i],"%REMOTE_HOST%",pfc,"REMOTE_HOST","<Unknown host>");i++;
 strcpy(cHost,cTagValue[i-1]);

//
// And everthing else if not specifically forbidden
//
 if (!dwJustCount)
 {
  TagServVar(cTagName[i],cTagValue[i],"%SERVER_SOFTWARE%",pfc,"SERVER_SOFTWARE","<Unknown server software>");i++;
  TagServVar(cTagName[i],cTagValue[i],"%CONTENT_LENGTH%",pfc,"CONTENT_LENGTH"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%CONTENT_TYPE%",pfc,"CONTENT_TYPE"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%GATEWAY_INTERFACE%",pfc,"GATEWAY_INTERFACE"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%PATH_INFO%",pfc,"PATH_INFO"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%PATH_TRANSLATED%",pfc,"PATH_TRANSLATED"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%QUERY_STRING%",pfc,"QUERY_STRING"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%REMOTE_USER%",pfc,"REMOTE_USER","<Anonymous>");i++;
  TagServVar(cTagName[i],cTagValue[i],"%REQUEST_METHOD%",pfc,"REQUEST_METHOD"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%SCRIPT_NAME%",pfc,"SCRIPT_NAME"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%SERVER_NAME%",pfc,"SERVER_NAME"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%SERVER_PORT%",pfc,"SERVER_PORT"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%SERVER_PROTOCOL%",pfc,"SERVER_PROTOCOL"," ");i++;
  TagServVar(cTagName[i],cTagValue[i],"%HTTP_ACCEPT%",pfc,"HTTP_ACCEPT"," ");i++;
  GetPrivateProfileString("LastAccess","cDate","<Unknown date>",cDate,sizeof(cDate),pcININame);TagConst(cTagName[i],cTagValue[i],"%LastAccessDate%",cDate);i++;
  GetPrivateProfileString("LastAccess","cTime","<Unknown time>",cTime,sizeof(cTime),pcININame);TagConst(cTagName[i],cTagValue[i],"%LastAccessTime%",cTime);i++;
  GetPrivateProfileString("LastAccess","cIP","<Unknown IP address>",cIP,sizeof(cIP),pcININame);TagConst(cTagName[i],cTagValue[i],"%LastClientIPAddress%",cIP);i++;
  GetPrivateProfileString("LastAccess","cHost","<Unknown host>",cLastHost,sizeof(cLastHost),pcININame);TagConst(cTagName[i],cTagValue[i],"%LastClientHost%",cLastHost);i++;
  GetPrivateProfileString("LastAccess","cBrowser","<Unknown browser>",cBrowser,sizeof(cBrowser),pcININame);TagConst(cTagName[i],cTagValue[i],"%LastClientBrowser%",cBrowser);i++;
//
// %Current~% Tags
//  
  FileTimeToSystemTime(&HTMInfo.ftLastWriteTime,&ST);
  ST2TM(&ST,&TM);
  strftime(cDate,sizeof(cDate),cDateFormat,&TM);TagConst(cTagName[i],cTagValue[i],"%LastFileUpdateDate%",cDate);i++;
  strftime(cTime,sizeof(cTime),cTimeFormat,&TM);TagConst(cTagName[i],cTagValue[i],"%LastFileUpdateTime%",cTime);i++;
  strftime(cDate,sizeof(cDate),cDateFormat,localtime(&Now));TagConst(cTagName[i],cTagValue[i],"%CurrentAccessDate%",cDate);i++;
  strftime(cTime,sizeof(cTime),cTimeFormat,localtime(&Now));TagConst(cTagName[i],cTagValue[i],"%CurrentAccessTime%",cTime);i++;
  strcpy(cIP,cRemoteIP);TagConst(cTagName[i],cTagValue[i],"%CurrentClientIPAddress%",cIP);i++;
  TagServVar(cTagName[i],cTagValue[i],"%HTTP_USER_AGENT%",pfc,"HTTP_USER_AGENT","<Unknown browser>");i++;
  strcpy(cBrowser,cTagValue[i-1]);TagConst(cTagName[i],cTagValue[i],"%CurrentClientBrowser%",cBrowser);i++;
 } // if(!dwJustCount)
 pfc->pFilterContext=(pfc->AllocMem)(pfc,dwHTMExSize,0);
 if (pfc->pFilterContext == NULL)
 {
  GlobalFree(pcHTM);
  ltoa(dwHTMExSize,cBuff,10);
  Report(EVENTLOG_ERROR_TYPE,207,"AllocMem(,%s,) failed.",cBuff);
  return;
 };
//
// Now we can finaly do it!
//
 pcS=pcHTM;
 pcD=(char*) pfc->pFilterContext;
 BOOL bCont=TRUE;
// *pcD='\0';
 memset(pcD,'\0',dwHTMExSize);
 while (bCont)
 {
  pcF1=strstr(pcS,cTagStart);
  if (pcF1)
  {
   iCat=pcF1-pcS;
   strncat(pcD,pcS,iCat);
   pcF2=strstr(pcF1+dwLenTS,cTagEnd);
   if (pcF2)
   {
   	if ((pcF2-pcF1)>=(int)(MAX_TAGNAME+dwLenTS)) // Too far, don't even try...
	{
	 strncat(pcD,pcF1,pcF2-pcF1+dwLenTE);
	 pcS=pcF2+dwLenTE;
	 bCont=TRUE;
	}
	else
	{
     int iRawTagLen=pcF2-(pcF1+dwLenTS);
	 strncpy(cRawTag,pcF1+dwLenTS,iRawTagLen);
	 cRawTag[iRawTagLen]='\0';
	 memset(cTagN,'\0',sizeof(cTagN));
	 sprintf(cTagN,"%%%s%%",cRawTag);
  	 bTagFound=FALSE;
 	 for(j=i-1;!bTagFound && (j>0);j--)
	 {
	  if (strcmp(cTagName[j],cTagN)==0)
	  {
	   strcat(pcD,cTagValue[j]);
	   bTagFound=TRUE;
	  };
	 }; // for(j...)
	 if (!bTagFound && (strcmp(cTagN,"%CurrentClientHost%")==0)) 
     {
      ResolveIPAddress(cHost);
	  TagConst(cTagName[i],cTagValue[i],"%CurrentClientHost%",cHost);i++;
	  strcat(pcD,cHost);
	  bTagFound=TRUE;
     };
	 if(!bTagFound && bExpandCTags && (i<MAX_TAG)) // not found and constant tags enabled
	 {
	  bTagFound=GetValueFromTagKeyInINI(pcININame,cTagN,cTagV) ? TRUE : GetValueFromTagKeyInReg(hKeyTags,cTagN,cTagV);
	  if (bTagFound)
	  {
	   TagConst(cTagName[i],cTagValue[i],cTagN,cTagV);i++;
   	   strcat(pcD,cTagV);
	  };
	 };
	 if(!bTagFound && bExpandRTags) // not found and random tags enabled
	 {
	  bTagFound=PickValueFromRandomKeyInINI(pcININame,cTagN,cTagV) ? TRUE : PickValueFromRandomKeyInReg(hKeyHTMLEx,cTagN,cTagV);
	  if (bTagFound) strcat(pcD,cTagV);
	 };
	 if (!bTagFound)		// Could not find it anywhere!
	 {
	  sprintf(cTagV,"%s%s%s",cTagStart,cRawTag,cTagEnd);
 	  sprintf(cBuff,"Tag %s in %s is unknown",cTagV,pcHTMName);
	  strcat(pcD,cTagV); 
      Report(EVENTLOG_WARNING_TYPE,106,"%s",cBuff);
	 };
     bCont=TRUE;
	 pcS=pcF2+dwLenTE;
    }
   }
   else	 // *pcF2==NULL
   {
    bCont=FALSE;
	iCat=strlen(pcF1);
    strncat(pcD,pcF1,iCat);
   }
  }
  else   // *pcF1==NULL
  {
   bCont=FALSE;
   iCat=strlen(pcS);
   strncat(pcD,pcS,iCat);
  };
 }; // while(bCont)

 GlobalFree(pcHTM);

 if (bCountThisHit)
 { 
//
// Update the INI File ([LastAccess] section)
//
  WritePrivateProfileString("LastAccess","cDate",cDate,pcININame);
  WritePrivateProfileString("LastAccess","cTime",cTime,pcININame);
  WritePrivateProfileString("LastAccess","cIP",cIP,pcININame);
  WritePrivateProfileString("LastAccess","cHost",cHost,pcININame);
  WritePrivateProfileString("LastAccess","cBrowser",cBrowser,pcININame);
  WritePrivateProfileString("LastAccess","iCnt",cTextCnt,pcININame);
//
// Write an entry into LOG File
// WriteProfileString cannot handle >64k, so we have to emulate it here
//
  if (dwRegGenerateLogs & dwLogThisOne)
  {
   HFILE LOGHandle=OpenFile(pcLOGName,&OFS,OF_WRITE | OF_SHARE_DENY_NONE);
   if (LOGHandle==HFILE_ERROR) // Failed because it doesn't exist yet?
   {
    LOGHandle=OpenFile(pcLOGName,&OFS,OF_CREATE | OF_SHARE_DENY_NONE);
    if (LOGHandle==HFILE_ERROR)
    {
     Report(EVENTLOG_ERROR_TYPE,208,"OpenFile(%s,,OF_CREATE | OF_SHARE_DENY_NONE) failed.",pcLOGName);
     return;										
    }
   };
   if (iMaxLogFileSize)
   {
    GetFileInformationByHandle((HANDLE) LOGHandle,&LOGInfo);
    if (bZapLOGFile=((LOGInfo.nFileSizeHigh>0) || (LOGInfo.nFileSizeLow>(DWORD) 1024*iMaxLogFileSize)))
    {
     sprintf(cBuff,"The Log file %s has grown over the allowed size of %i kilobyte(s), and has been zapped",pcLOGName,iMaxLogFileSize);
     Report(EVENTLOG_INFORMATION_TYPE,9,"%s",cBuff);
    }
   }
   else bZapLOGFile=FALSE; // ==0, grow ad infinitum!
   SetFilePointer((HANDLE) LOGHandle,0,NULL,bZapLOGFile ? FILE_BEGIN : FILE_END);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"[%i]\r\n",iCnt),&dwFileRW,NULL);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"cDate=%s\r\n",cDate),&dwFileRW,NULL);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"cTime=%s\r\n",cTime),&dwFileRW,NULL);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"cIP=%s\r\n",cIP),&dwFileRW,NULL);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"cHost=%s\r\n",cHost),&dwFileRW,NULL);
   WriteFile((HANDLE) LOGHandle,cBuff,sprintf(cBuff,"cBrowser=%s\r\n\r\n",cBrowser),&dwFileRW,NULL);
   if (bZapLOGFile) SetEndOfFile((HANDLE) LOGHandle);
   CloseHandle((HANDLE) LOGHandle);
  }; // if (dwRegGenetateLogs)
 };  // if (!bCountThisHit)
// Report(EVENTLOG_INFORMATION_TYPE,8,"%s",(char*) pfc->pFilterContext);
};

BOOL WINAPI SetDebugMode(HANDLE hSE)
{
 bDebugMode=TRUE;
 hStdErr=hSE;
 return (TRUE);
};

BOOL WINAPI GetFilterVersion(HTTP_FILTER_VERSION *pVer)
{
 HKEY  hKeyW3SVC,hKeyParams,hKeyDigits;
 DWORD dwValLen;
 char  cRegSkipdir[MAX_SKIPDIR*256];
 int j;
 const char *pcDefaultDigitVal[]={"0","1","2","3","4","5","6","7","8","9"};

 pVer->dwFlags = (SF_NOTIFY_NONSECURE_PORT     |
                  SF_NOTIFY_SECURE_PORT        | //ATTENTION: NEVER TRIED IT!
      		      SF_NOTIFY_URL_MAP            |
		          SF_NOTIFY_SEND_RAW_DATA      |
  	     	      SF_NOTIFY_ORDER_DEFAULT);
 pVer->dwFilterVersion = HTTP_FILTER_REVISION;
 strcpy(pVer->lpszFilterDesc,pcHTMLExDesc);
 hEvent=RegisterEventSource(NULL,"HTMLEx");
 Report(EVENTLOG_INFORMATION_TYPE,0,"GetFilterVersion: %s",pVer->lpszFilterDesc);
// Set default values
 strcpy(cRegTagStart,TAG_START);
 strcpy(cRegTagEnd,TAG_END);
 strcpy(cRegDefault_Load_File,DEFAULTLOADFILE);
 strcpy(cRegIgnoreAddress,IGNOREADDRESS);
 strcpy(cRegExpandableExtensions,EXPANDABLEEXTENSIONS);
 strcpy(cRegUnexpandableExtensions,UNEXPANDABLEEXTENSIONS);
 strcpy(cRegDateFormat,DATEFORMAT);
 strcpy(cRegTimeFormat,TIMEFORMAT);
 for(j=0;j<10;j++) strcpy(cRegDigitImg[j],pcDefaultDigitImg[j]);
 dwRegDigitCnt=DIGITCNT;
 dwRegMaxLogFileSize=MAXLOGFILESIZE;
 dwRegExpandByDefault=EXPANDBYDEFAULT;
 dwRegExpandDefaultPages=EXPANDDEFAULTPAGES;
 dwRegExpandOtherPages=EXPANDOTHERPAGES;
 dwRegGenerateLogs=GENERATELOGS;
 iSkipdirCount=0;
// Override with registry
 hKeyHTMLEx=NULL;
 hKeyTags=NULL;
 if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,KEY_W3SVC,0,KEY_READ,&hKeyW3SVC)==ERROR_SUCCESS)
 {

  if (RegOpenKeyEx(hKeyW3SVC,KEY_PARAMS,0,KEY_READ,&hKeyParams)==ERROR_SUCCESS) 
  {
   dwValLen=sizeof(cRegDefault_Load_File);
   if (RegQueryValueEx(hKeyParams,"Default Load File",NULL,NULL,(LPBYTE) cRegDefault_Load_File,&dwValLen) != ERROR_SUCCESS)
      strcpy(cRegDefault_Load_File,DEFAULTLOADFILE);
   RegCloseKey(&hKeyParams);
  }
  else Report(EVENTLOG_ERROR_TYPE,200,"RegOpenKeyEx(W3SVC\\Parameters) failed - check your IIS installation",NULL);
 
  if (RegOpenKeyEx(hKeyW3SVC,KEY_HTMLEX,0,KEY_READ,&hKeyHTMLEx)==ERROR_SUCCESS)
  {
   if (RegOpenKeyEx(hKeyHTMLEx,KEY_TAGS,0,KEY_READ,&hKeyTags) != ERROR_SUCCESS)
   {
    Report(EVENTLOG_WARNING_TYPE,100,"RegOpenKeyEx(W3SVC\\HTMLEx\\Tags) failed - no constant tags in registry",NULL);
    hKeyTags=NULL;
   };
   dwValLen=sizeof(cRegSkipdir);
   if (RegQueryValueEx(hKeyHTMLEx,"SkipDirectories",NULL,NULL,(LPBYTE) cRegSkipdir,&dwValLen) == ERROR_SUCCESS)
   {
    char *pcS=strupr(cRegSkipdir),*pcE;
	do
	{
	 if (iSkipdirCount<MAX_SKIPDIR)
	 {
	  strnset(cSkipdir[++iSkipdirCount],'\0',sizeof(cSkipdir[0]));
	  pcE=strchr(pcS,',');
	  if (pcE) 
	  {
	   strncpy(cSkipdir[iSkipdirCount],pcS,pcE-pcS);
	   pcS=pcE+1;
	  }
	  else strcpy(cSkipdir[iSkipdirCount],pcS);
//    Report(EVENTLOG_WARNING_TYPE,999,"All URLs from '%s' will be skipped",cSkipdir[iSkipdirCount]);
	 };
	} while (pcE);
   };
   dwValLen=sizeof(cRegTagStart);
   if (RegQueryValueEx(hKeyHTMLEx,"TagStart",NULL,NULL,(LPBYTE) cRegTagStart,&dwValLen) != ERROR_SUCCESS) strcpy(cRegTagStart,TAG_START);
   dwValLen=sizeof(cRegTagEnd);
   if (RegQueryValueEx(hKeyHTMLEx,"TagEnd",NULL,NULL,(LPBYTE) cRegTagEnd,&dwValLen) != ERROR_SUCCESS) strcpy(cRegTagStart,TAG_END);
   dwValLen=sizeof(cRegIgnoreAddress);
   if (RegQueryValueEx(hKeyHTMLEx,"IgnoreAddress",NULL,NULL,(LPBYTE) cRegIgnoreAddress,&dwValLen) != ERROR_SUCCESS) strcpy(cRegIgnoreAddress,IGNOREADDRESS);
   dwValLen=sizeof(cRegExpandableExtensions);
   if (RegQueryValueEx(hKeyHTMLEx,"ExpandableExtensions",NULL,NULL,(LPBYTE) cRegExpandableExtensions,&dwValLen) != ERROR_SUCCESS) strcpy(cRegExpandableExtensions,EXPANDABLEEXTENSIONS);
   dwValLen=sizeof(cRegUnexpandableExtensions);
   if (RegQueryValueEx(hKeyHTMLEx,"UnexpandableExtensions",NULL,NULL,(LPBYTE) cRegUnexpandableExtensions,&dwValLen) != ERROR_SUCCESS) strcpy(cRegUnexpandableExtensions,UNEXPANDABLEEXTENSIONS);
   dwValLen=sizeof(cRegDateFormat);
   if (RegQueryValueEx(hKeyHTMLEx,"DateFormat",NULL,NULL,(LPBYTE) cRegDateFormat,&dwValLen) != ERROR_SUCCESS) strcpy(cRegDateFormat,DATEFORMAT);
   dwValLen=sizeof(cRegTimeFormat);
   if (RegQueryValueEx(hKeyHTMLEx,"TimeFormat",NULL,NULL,(LPBYTE) cRegTimeFormat,&dwValLen) != ERROR_SUCCESS) strcpy(cRegTimeFormat,TIMEFORMAT);
   dwValLen=sizeof(dwRegDigitCnt);
   if (RegQueryValueEx(hKeyHTMLEx,"DigitCnt",NULL,NULL,(LPBYTE) &dwRegDigitCnt,&dwValLen) != ERROR_SUCCESS) dwRegDigitCnt=DIGITCNT;
   if (RegOpenKeyEx(hKeyHTMLEx,KEY_DIGITS,0,KEY_READ,&hKeyDigits)==ERROR_SUCCESS)
   {
    for(j=0;j<10;j++)
    {
     dwValLen=sizeof(cRegDigitImg[0]);
     if (RegQueryValueEx(hKeyDigits,(char*) pcDefaultDigitVal[j],NULL,NULL,(LPBYTE) cRegDigitImg[j],&dwValLen) != ERROR_SUCCESS) strcpy(cRegDigitImg[j],pcDefaultDigitImg[j]);
    };
	RegCloseKey(&hKeyDigits);
   }
   else Report(EVENTLOG_WARNING_TYPE,101,"RegOpenKeyEx(W3SVC\\HTMLEx\\Digits) failed - using defaults",NULL);

   dwValLen=sizeof(dwRegMaxLogFileSize);
   if (RegQueryValueEx(hKeyHTMLEx,"MaxLogFileSize",NULL,NULL,(LPBYTE) &dwRegMaxLogFileSize,&dwValLen) != ERROR_SUCCESS) dwRegMaxLogFileSize=MAXLOGFILESIZE;
   dwValLen=sizeof(dwRegExpandByDefault);
   if (RegQueryValueEx(hKeyHTMLEx,"ExpandByDefault",NULL,NULL,(LPBYTE) &dwRegExpandByDefault,&dwValLen) != ERROR_SUCCESS) dwRegExpandByDefault=EXPANDBYDEFAULT;
   dwValLen=sizeof(dwRegExpandDefaultPages);
   if (RegQueryValueEx(hKeyHTMLEx,"ExpandDefaultPages",NULL,NULL,(LPBYTE) &dwRegExpandDefaultPages,&dwValLen) != ERROR_SUCCESS) dwRegExpandDefaultPages=EXPANDDEFAULTPAGES;
   dwValLen=sizeof(dwRegExpandOtherPages);
   if (RegQueryValueEx(hKeyHTMLEx,"ExpandOtherPages",NULL,NULL,(LPBYTE) &dwRegExpandOtherPages,&dwValLen) != ERROR_SUCCESS) dwRegExpandOtherPages=EXPANDOTHERPAGES;
   dwValLen=sizeof(dwRegGenerateLogs);
   if (RegQueryValueEx(hKeyHTMLEx,"GenerateLogs",NULL,NULL,(LPBYTE) &dwRegGenerateLogs,&dwValLen) != ERROR_SUCCESS) dwRegGenerateLogs=GENERATELOGS;
// RegCloseKey(&hKeyHTMLEx); DO NOT CLOSE IT - WILL READ RANDOM KEYS FROM HERE!!!
  }
  else
  {
   Report(EVENTLOG_WARNING_TYPE,102,"RegOpenKeyEx(W3SVC\\HTMLEx) failed - using defaults",NULL);
   hKeyHTMLEx=NULL;
  };
  RegCloseKey(hKeyW3SVC);
 
 }
 else Report(EVENTLOG_ERROR_TYPE,201,"RegOpenKeyEx(W3SVC) failed",NULL);
 strupr(cRegExpandableExtensions);   // Needed: comparison is case sensitive!
 strupr(cRegUnexpandableExtensions); // Needed: comparison is case sensitive!
 strupr(cRegDefault_Load_File);      // Needed: comparison is case sensitive!
 return TRUE;
}

DWORD WINAPI HttpFilterProc(HTTP_FILTER_CONTEXT *pfc,DWORD dwNotificationType,VOID *pvData)
{
 switch (dwNotificationType)
 {
  case SF_NOTIFY_URL_MAP:
       {
	    char cHTMName[256],cININame[256],cLOGName[256];
 	    pfc->pFilterContext = NULL; //Default is no messing around
 	    HTTP_FILTER_URL_MAP* pURLMap = (PHTTP_FILTER_URL_MAP) pvData;
	    char* pcPhysPath = pURLMap->pszPhysicalPath; 
		char* pcLastBackslashPos=strrchr(pcPhysPath,'\\');
		if (pcLastBackslashPos)
		{
		 strupr(pcPhysPath); // Needed: comparison is case sensitive!
	     char* pcLastDotPos=strrchr(pcLastBackslashPos,'.');
	     if (pcLastDotPos)
	     {		   
		  if(strstr(cRegExpandableExtensions,pcLastDotPos))
	      {
//         Report(EVENTLOG_INFORMATION_TYPE,10,"pcPhysPath=%s",pcPhysPath);
	       char* pcFirstDotPos=strchr(pcLastBackslashPos,'.');
		   if (pcFirstDotPos)
		   {
		    char cFirstExtension[16];
		    char* pcFirstExtension=strnset(cFirstExtension,'\0',16);
		    *pcFirstExtension++=*pcFirstDotPos++; // copy the dot!								 
		    while(isalnum(*pcFirstDotPos)) *pcFirstExtension++=*pcFirstDotPos++;
		    if(strstr(cRegUnexpandableExtensions,cFirstExtension))
			{
//           Report(EVENTLOG_INFORMATION_TYPE,11,"Unexpandable extension found in %s",pcPhysPath);
		     return SF_STATUS_REQ_NEXT_NOTIFICATION;;
			};
		   };
		   if (iSkipdirCount)
		   {
		    char cHTMDir[256];
			strncpy(cHTMDir,pcPhysPath,pcLastBackslashPos-pcPhysPath+1);
			cHTMDir[pcLastBackslashPos-pcPhysPath+1]='\0';
//          Report(EVENTLOG_WARNING_TYPE,998,"cHTMDir='%s'",cHTMDir);
		    for(int i=iSkipdirCount;i>0;i--)
		    if(strstr(cHTMDir,cSkipdir[i]))
			{
//           Report(EVENTLOG_INFORMATION_TYPE,12,"Processing of %s skipped due to its directory",pcPhysPath);
		     return SF_STATUS_REQ_NEXT_NOTIFICATION;
			};
		   };
		   strcpy(cHTMName,pcPhysPath);
		   if (strstr(strupr(cHTMName),cRegDefault_Load_File)) // Is this a default page?
		   {  ///// DEFAULT FILE
		    if (dwRegExpandDefaultPages)
		    {
 		     strcpy(cININame,pcPhysPath);strcpy(strrchr(cININame,'.'),".ini");
		     strcpy(cLOGName,pcPhysPath);strcpy(strrchr(cLOGName,'.'),".log");
		     HTMLExpand(pfc,cHTMName,cININame,cLOGName);
		    }
		   }
		   else
		   {	 ///// ANY OTHER FILE
		    if (dwRegExpandOtherPages)
		    {
		     strcpy(cININame,pcPhysPath);strcpy(strrchr(cININame,'.'),".ini");
		     strcpy(cLOGName,pcPhysPath);strcpy(strrchr(cLOGName,'.'),".log");
		     HTMLExpand(pfc,cHTMName,cININame,cLOGName);
		    }
		   };  // if (default/not default)
		  };   // if (expandable)
	     };    // if (pcDotPos)
		};     // if (pcLastBacklashPos)
	   };
	   break;
  case SF_NOTIFY_SEND_RAW_DATA:
       {
        HTTP_FILTER_RAW_DATA* pRawData = (PHTTP_FILTER_RAW_DATA) pvData;
	    if (pfc->pFilterContext)                            //HYPERTEXT? 
	    {
	     DWORD dwExpandedLen=strlen((char*) pfc->pFilterContext);
		 if (strstr((char*) pRawData->pvInData,"HTTP/1.0")) //HEADER
		 {

		  char cBuff[2048];memset(cBuff,'\0',sizeof(cBuff));
		  char* pcBefore=(char*) memcpy(cBuff,pRawData->pvInData,pRawData->cbInData);
		  char* pcBetween=strstr(pcBefore,"Content-Length:");
		  if (pcBetween)
		  {
		   char* pcAfter=pcBetween;
		   while (*pcAfter>=' ') pcAfter++;
		   *pcBetween='\0';
		   sprintf((char*) pRawData->pvInData,"%sContent-Length: %i%s",pcBefore,dwExpandedLen,pcAfter);
		   pRawData->cbInData=(DWORD) strlen((char*) pRawData->pvInData);
		  };

		 }
		 else												 //BODY
		 {
//		  char cDebug[256];
//		  sprintf(cDebug,"%lx %li %li %li",pfc->pFilterContext,dwExpandedLen,pRawData->cbInData,pRawData->cbInBuffer);
//        Report(EVENTLOG_INFORMATION_TYPE,1,"Body - %s",cDebug);
		  pRawData->cbInBuffer=MAX_WRITEBUFF;
		  pRawData->pvInData=pfc->pFilterContext;
          if (dwExpandedLen<=MAX_WRITEBUFF)
		  {
	       pRawData->cbInData=dwExpandedLen;
		   pfc->pFilterContext=NULL;                                      //LAST CHUNK
		  }
		  else
		  {
	       pRawData->cbInData=MAX_WRITEBUFF;
		   pfc->pFilterContext=(char*) pfc->pFilterContext+MAX_WRITEBUFF; //NEXT CHUNK
		  }; // if()
		 };	 // if(HEADER)
		}
//		else Report(EVENTLOG_INFORMATION_TYPE,2,"pfc->pFilterContext=NULL\n%s",(char*) pRawData->pvInData);
       };
	   break;
  };
  return SF_STATUS_REQ_NEXT_NOTIFICATION;
}
// *EOF*
